package org.msh.tb.bd.tbforms.dhis2.tb11.blockbuilders;

import org.msh.tb.bd.tbforms.dhis2.SexCategoryOptionCombo;
import org.msh.tb.bd.tbforms.dhis2.TBFormBlockBuilder;
import org.msh.tb.bd.tbforms.dhis2.data.DataValuePayload;
import org.msh.tb.bd.tbforms.query.TbFormQuery;
import org.msh.tb.bd.tbforms.query.tb11.TBForm11Block3HIVActivitiesQuery;
import org.msh.tb.entities.enums.Gender;

/**
 * Created by Mauricio on 20/03/2017.
 * Mount TB Form 11 Block 3 table 2 Payload to be sent to DHIS2 APIs
 */
public class TBForm11Block3HIVActivitiesBuilder extends TBFormBlockBuilder {

    private TBForm11Block3HIVActivitiesQuery blockQuery;

    @Override
    protected void loadAllFieldsAsZero(DataValuePayload payload) {
        for(TBForm11Block2DataElement elem : TBForm11Block2DataElement.values()) {
            payload.mergeDataValue(elem.getDataElementId(), SexCategoryOptionCombo.MALE.getCocId(), new Long(0));
            payload.mergeDataValue(elem.getDataElementId(), SexCategoryOptionCombo.FEMALE.getCocId(), new Long(0));
        }
    }

    @Override
    protected TbFormQuery getBlockQuery() {
        if (blockQuery == null) {
            blockQuery = new TBForm11Block3HIVActivitiesQuery();
        }
        return blockQuery;
    }

    @Override
    protected void mountResultPayload(Object[] result, DataValuePayload payload) {
        String type = (String) result[0];
        Gender gender = (Gender) result[1];
        Long count = (Long) result[2];

        payload.mergeDataValue(TBForm11Block2DataElement.findId(type), SexCategoryOptionCombo.findCocId(gender), count);
    }

    public enum TBForm11Block2DataElement {
        ART("ART", "bYdjXHkJS2b"),
        CPT("CPT", "tD6wy8GFDho"),
        TOTAL("TOTAL", "Nnl5NDIM6Yr");

        private String type;

        private String DataElementId;

        TBForm11Block2DataElement(String type, String dataElementId) {
            this.type = type;
            DataElementId = dataElementId;
        }

        public String getType() {
            return type;
        }

        public String getDataElementId() {
            return DataElementId;
        }

        public static String findId(String type) {
            for(TBForm11Block2DataElement elem : values()) {
                if (elem.getType().equals(type)) {
                    return elem.getDataElementId();
                }
            }

            throw new RuntimeException("TBForm11Block2DataElement: type" + type + " not found");
        }
    }

}
